/* Code to find the device path for a usbprint.sys controlled 
 * usb printer and print to it
 */
#include <windows.h>
#include <setupapi.h>
#include <devguid.h>
#include <initguid.h>
#include <tchar.h>
#include "usbprint.h"

#pragma comment(lib,"setupapi.lib")

#define DATA_OUT  "PIPE0"//"PIPE0"
#define DATA_IN   "PIPE1"//"PIPE1"

/* This define is required so that the GUID_DEVINTERFACE_USBPRINT variable is
 * declared an initialised as a static locally, since windows does not include it in any
 * of its libraries
 */
//#define USB_VID 0x067B
//#define USB_PID 0x2305
//#define USB_DEV_SERIAL_NO  "5&3c291ef&0&1"
//DEFINE_GUID(GUID_DEVINTERFACE_USBCOM,0xa5dcbf10,0x6530,0x11d2,0x90,0x1f,0x00,0xc0,0x4f,0xb9,0x51,0xed);

DEFINE_GUID(GUID_DEVINTERFACE_USBPRINT, 0x28d78fad, 0x5a12, 0x11D1, 0xae, 0x5b, 0x00, 0x00, 0xf8, 0x03, 0xa8, 0xc2);
DEFINE_GUID(GUID_DEVINTERFACE_USBCOMPOSITE, 0xa5dcbf10,0x6530,0x11d2,0x90,0x1f,0x00,0xc0,0x4f,0xb9,0x51,0xed);


void GetVendorID(char *DevicePath,int *vendorID,int *productID)
{
	char i;
	char vid[5],pid[5];
	for(i=0;i<4;i++){ 
		vid[i]=*(DevicePath+12+i); 
	} 
	vid[4]='\0'; 
	for(i=0;i<4;i++){ 
		pid[i]=*(DevicePath+21+i); 
	} 
	pid[4]='\0';
	*vendorID=_tcstoul(vid,0,16);
	*productID=_tcstoul(pid,0,16);
}

void GetSerialNo(char *DevicePath,char *serialNo)
{
	int i=0;
	do
	{ 
		serialNo[i]=*(DevicePath+26+i); 
        i++;
		if(i==MAX_PATH)
			break;
	}while((*(DevicePath+26+i)!=0) && (*(DevicePath+26+i) != '#'));
	serialNo[i]='\0'; 
}

void GetInterFaceNo(char *DevicePath,char *InterFaceNo)
{
	int i=0;
	do
	{ 
		InterFaceNo[i]=*(DevicePath+26+i); 
        i++;
		if(i==MAX_PATH)
			break;
	}while((*(DevicePath+26+i)!=0) && (*(DevicePath+26+i) != '#'));
	InterFaceNo[i]='\0'; 
}

//-------------------------------------------------------------------
unsigned char CheckUsbSerialNo(char *DevicePath,char *serialNo)
{
	char SerialNo1[2048];
	GetSerialNo(DevicePath,SerialNo1);
	if(strcmp(SerialNo1,serialNo)==0)
	{
	return TRUE;
	}
	return FALSE;
}
unsigned char CheckUsbVidPid(char *DevicePath,int vendorID,int productID)
{
	int vid,pid;
	GetVendorID(DevicePath,&vid,&pid);
	if(vendorID==vid && productID==pid)
		return TRUE;
	return FALSE;
}
//-------------------------------------------------------------------

unsigned short GetUsbDeviceName(GUID intfce,USB_DEVICE_INFO *pUSBDeviceInfo,BOOL IsSubDevice)
{
  HANDLE usbHandle;
  HDEVINFO devs;
  DWORD devcount;
  SP_DEVINFO_DATA devinfo;
  SP_DEVICE_INTERFACE_DATA devinterface;
  DWORD size;
  unsigned short count=0;
  //GUID intfce;
  PSP_DEVICE_INTERFACE_DETAIL_DATA interface_detail;
  char driverkey[2048];
  char interfacename[2048];
  char location[2048];
  //char description[2048];
  char hardwareid[2048];
  int vid,pid;
  //char SerialNo1[2048];
  //char InterfaceNo1[255];

  //intfce = GUID_DEVINTERFACE_USBPRINT;
  devs = SetupDiGetClassDevs(&intfce, 0, 0, DIGCF_PRESENT | DIGCF_DEVICEINTERFACE);
  if (devs == INVALID_HANDLE_VALUE) {
    return FALSE;
  }
  devcount = 0;
  devinterface.cbSize = sizeof(SP_DEVICE_INTERFACE_DATA);
  while (SetupDiEnumDeviceInterfaces(devs, 0, &intfce, devcount, &devinterface)) 
  {
    /* The following buffers would normally be malloced to he correct size
     * but here we just declare them as large stack variables
     * to make the code more readable
     */

    /* If this is not the device we want, we would normally continue onto the next one
     * so something like if (!required_device) continue; would be added here
     */
    devcount++;
    size = 0;
    /* See how large a buffer we require for the device interface details */
    SetupDiGetDeviceInterfaceDetail(devs, &devinterface, 0, 0, &size, 0);
    devinfo.cbSize = sizeof(SP_DEVINFO_DATA);
    interface_detail =(PSP_DEVICE_INTERFACE_DETAIL_DATA) calloc(1, size);
    if (interface_detail)
	{
      interface_detail->cbSize = sizeof (SP_DEVICE_INTERFACE_DETAIL_DATA);
      devinfo.cbSize = sizeof(SP_DEVINFO_DATA);
      if (!SetupDiGetDeviceInterfaceDetail(devs, &devinterface, interface_detail, size, 0, &devinfo))
	  {
			free(interface_detail);
			SetupDiDestroyDeviceInfoList(devs);
			return FALSE;
      }
      /* Make a copy of the device path for later use */
      strcpy(interfacename, interface_detail->DevicePath);
      free(interface_detail);
	  //--------------------------------------------------
	  GetVendorID(interfacename,&vid,&pid);
	  if(pUSBDeviceInfo->vid!=vid || pUSBDeviceInfo->pid!=pid)
		  continue;
	  //--------------------------------------------------
      /* And now fetch some useful registry entries */
      size = sizeof(driverkey);
      driverkey[0] = 0;
      if (!SetupDiGetDeviceRegistryProperty(devs, &devinfo, SPDRP_DRIVER, NULL, (LPBYTE)driverkey, size, 0)) 
	  {
			//SetupDiDestroyDeviceInfoList(devs);
			//return FALSE;
		  continue;
      }
	  if(IsSubDevice==FALSE)
	  {
		size = sizeof(location);
		location[0] = 0;
		if (!SetupDiGetDeviceRegistryProperty(devs, &devinfo, SPDRP_LOCATION_INFORMATION, NULL, (LPBYTE)location, size, 0)) 
		{
	  		//SetupDiDestroyDeviceInfoList(devs);
	  		//return FALSE;
			continue;
		}
	  }
	  size = sizeof(hardwareid);
	  hardwareid[0] = 0;
	  if (!SetupDiGetDeviceRegistryProperty(devs, &devinfo, SPDRP_HARDWAREID, NULL, (LPBYTE)hardwareid, size, 0)) 
	  {
		  //SetupDiDestroyDeviceInfoList(devs);
		  //return FALSE;
		  continue;
      }
	  
      usbHandle = CreateFile(interfacename, GENERIC_WRITE, FILE_SHARE_READ,
	  		     NULL, OPEN_ALWAYS, FILE_ATTRIBUTE_NORMAL | FILE_FLAG_SEQUENTIAL_SCAN, NULL);
      if(usbHandle != INVALID_HANDLE_VALUE)
	  {
	/* Now perform all the writing to the device ie.
	 * while (some condition) WriteFile(usbHandle, buf, size, &bytes_written);
	 */
	    CloseHandle(usbHandle);
		strcpy(pUSBDeviceInfo->DeviceName[count], interfacename);
		GetSerialNo(interfacename,pUSBDeviceInfo->SerialNo[count]);
		pUSBDeviceInfo->count++;
       count++;
      }
    }
  }
  SetupDiDestroyDeviceInfoList(devs);
  return count;
}

HANDLE OpenOnePipe(char *pDeviceName,const char *PipeName)
{
	char m_DeviceName[MAX_PATH] = "";
	strcpy(m_DeviceName,pDeviceName);
	strcat(m_DeviceName,"\\");
	strcat(m_DeviceName,PipeName);
	//return CreateFile(m_DeviceName, GENERIC_WRITE|GENERIC_READ, FILE_SHARE_WRITE|FILE_SHARE_READ, NULL, OPEN_EXISTING, 0, NULL);
	return CreateFile(m_DeviceName, GENERIC_WRITE|GENERIC_READ, FILE_SHARE_WRITE|FILE_SHARE_READ, NULL, OPEN_EXISTING, FILE_ATTRIBUTE_NORMAL|FILE_FLAG_OVERLAPPED, NULL);
}

void CloseOnePipe(HANDLE hPipe)
{
	CloseHandle(hPipe);
}


char DeviceName[MAX_PATH] = "";
USB_DEVICE_INFO USBDeviceInfo;
unsigned int USBDevIndex=0;
unsigned char EnumUsbDevice(void)
{
	unsigned int i;
	USBDeviceInfo.count=0;
	USBDeviceInfo.vid=USB_VID;
	USBDeviceInfo.pid=USB_PID;
	for(i=0;i<256;i++)
	{
		memset(&USBDeviceInfo.SerialNo[i][0],0,MAX_PATH);
		memset(&USBDeviceInfo.DeviceName[i][0],0,MAX_PATH);
	}
	//char Name[MAX_PATH] = "";
    GetUsbDeviceName(GUID_DEVINTERFACE_USBPRINT,&USBDeviceInfo,FALSE);
	//if(GetUsbDeviceName(GUID_DEVINTERFACE_USBCOMPOSITE,USB_VID,USB_PID,USB_DEV_SERIAL_NO,NULL,Name,FALSE)==FALSE)
	//	return FALSE;
    //GetUsbDeviceName(GUID_DEVINTERFACE_USBPRINT,&USBDeviceInfo,TRUE);
	if(USBDeviceInfo.count)
		return TRUE;
	return FALSE;
}

/*
unsigned int WritePipe(char *pDeviceName,char *PipeName,unsigned char *Buffer,unsigned int Size)
{
	DWORD nBytesWritten;
	HANDLE hPipe;
	hPipe = OpenOnePipe(pDeviceName,PipeName); // Pipe , Ӧĳ˵ I/O, Ҫһ
	if(hPipe != INVALID_HANDLE_VALUE) // Pipe ɹ
	{
		WriteFile(hPipe, Buffer, Size, &nBytesWritten, NULL); // Buffer  Size ֽд hPipe
		CloseOnePipe(hPipe);
	}
	return nBytesWritten;
}

unsigned int  ReadPipe(char *pDeviceName,char *PipeName,unsigned char *Buffer,unsigned int Size)
{
	DWORD nBytesRead;
	HANDLE hPipe;
	hPipe = OpenOnePipe(pDeviceName,PipeName); // Pipe , Ӧĳ˵ I/O,  Ҫһ
	if(hPipe != INVALID_HANDLE_VALUE) // Pipe ɹ
	{
		ReadFile(hPipe, Buffer, Size, &nBytesRead, NULL); // hPipe ȡݵ Buffer 
		CloseOnePipe(hPipe);
	}
	return nBytesRead;
}
*/
unsigned int WritePipe(char *pDeviceName,char *PipeName,unsigned char *Buffer,unsigned int Size,unsigned int TimeOut)
{
	unsigned long WaitTime;
	OVERLAPPED ol;
	DWORD dwError;
	DWORD nBytesWritten=0;
	HANDLE hPipe;
	hPipe = OpenOnePipe(pDeviceName,PipeName); // Pipe , Ӧĳ˵ I/O, Ҫһ
	if(hPipe != INVALID_HANDLE_VALUE) // Pipe ɹ
	{
		ol.Offset=0; //豸ʹָ0            
		ol.OffsetHigh=0; //豸ʹָ0
		ol.hEvent=NULL;   //ʶ¼Ϊź״̬ݴʱΪź״̬
		ol.hEvent=CreateEvent(NULL,TRUE,FALSE,NULL); 
		if(!WriteFile(hPipe, Buffer, Size, &nBytesWritten, &ol))//
		{
			//Ϣ--------------------------------
			dwError=GetLastError();
			if(dwError==ERROR_IO_PENDING)
			{
				WaitTime=GetTickCount()+TimeOut;
				while(!GetOverlappedResult(hPipe,&ol,&nBytesWritten,FALSE))
				{   
					if(GetTickCount()>WaitTime)
					{   		
						break;
					}
					dwError=GetLastError();
					if(dwError==ERROR_IO_INCOMPLETE) 
						continue;          //δȫʱؽ
					else
					{
						//󣬳Իָ                    
						break;
					}
				}
			} 
			else if(dwError==ERROR_ACCESS_DENIED)//޷Ȩ
			{

			}
			//-------------------------------------------------
		}
		CloseHandle(ol.hEvent);
		FlushFileBuffers(hPipe); 
		CloseOnePipe(hPipe);
	}
	return nBytesWritten;
}

unsigned int  ReadPipe(char *pDeviceName,char *PipeName,unsigned char *Buffer,unsigned int Size,unsigned int TimeOut)
{
	DWORD dwError;
	unsigned long WaitTime;
	OVERLAPPED ol;
	DWORD nBytesRead=0;
	DWORD nBytes=0;
	HANDLE hPipe;
	DWORD nReadNum=0;
	hPipe = OpenOnePipe(pDeviceName,PipeName); // Pipe , Ӧĳ˵ I/O,  Ҫһ
	if(hPipe != INVALID_HANDLE_VALUE) // Pipe ɹ
	{
		nReadNum=Size;
		ol.Offset=0;                            ///ļʼֽƫ
		ol.OffsetHigh=0;                        ///ʼݵֽƫĸλ֣ܵͨʱý̿ɺԡ
		ol.hEvent=NULL;                         ///ʶ¼ݴʱΪź״̬
		ol.hEvent=CreateEvent(NULL,TRUE,FALSE,NULL); 
		WaitTime=GetTickCount()+TimeOut;//GetTickCount()ȡϵͳʼõʱ()
	  while(GetTickCount()<WaitTime && nBytes<Size)
	  {
		nBytesRead=0;
		ol.Offset=0;
		ol.OffsetHigh=0;
		if(!ReadFile(hPipe, Buffer, nReadNum, &nBytesRead, &ol))//
		{
			dwError=GetLastError();
			if(dwError==ERROR_IO_PENDING)
			{
				///////////////////	
				while(!GetOverlappedResult(hPipe,&ol,&nBytesRead,FALSE))//úȡصĽ
				{
					if(GetTickCount()>WaitTime)
					{   		
						break;
					}
					dwError=GetLastError();
					if(dwError==ERROR_IO_INCOMPLETE) 
						continue;          //δȫʱؽ
					else
					{
						//󣬳Իָ                    
						break;
					}
				}    
			} 
			else if(dwError==ERROR_ACCESS_DENIED)//޷Ȩ
			{
				
			}
		}
		nBytes=nBytes+nBytesRead;
		nReadNum=nReadNum-nBytesRead;
	  }
		CloseHandle(ol.hEvent);
		CloseOnePipe(hPipe);
	}
	return nBytes;
}

unsigned int UsbWriteBytes(unsigned char *Buffer,unsigned int Size,unsigned int TimeOut)
{
	return WritePipe(USBDeviceInfo.DeviceName[USBDevIndex],DATA_OUT,Buffer,Size,TimeOut);
}

unsigned int UsbReadBytes(unsigned char *Buffer,unsigned int Size,unsigned int TimeOut)
{
	return ReadPipe(USBDeviceInfo.DeviceName[USBDevIndex],DATA_IN,Buffer,Size,TimeOut);
}

unsigned char CheckUSBOnline(void)
{
	HANDLE hPipe;
	char m_DeviceName[MAX_PATH] = "";
	strcpy(m_DeviceName,USBDeviceInfo.DeviceName[USBDevIndex]);
	strcat(m_DeviceName,"\\");
	strcat(m_DeviceName,DATA_IN);
	hPipe = CreateFile(m_DeviceName, GENERIC_WRITE|GENERIC_READ, FILE_SHARE_WRITE|FILE_SHARE_READ, NULL, OPEN_EXISTING, 0, NULL);
    if(hPipe == INVALID_HANDLE_VALUE) // Pipe ʧ
		return FALSE;
	CloseHandle(hPipe);
	return TRUE;
}
/*
int WriteUsb(HANDLE hUsb,char *Outbuff, int len)
{
    DWORD nBytesWrite,endtime,lrc;
    static OVERLAPPED ol;
    DWORD dwErrorMask,dwError;
    COMSTAT comstat;
	if(hUsb==NULL)
		return 0;
    ol.Offset=0; //豸ʹָ0            
    ol.OffsetHigh=0; //豸ʹָ0
    ol.hEvent=NULL;   //ʶ¼Ϊź״̬ݴʱΪź״̬
    ol.hEvent=CreateEvent(NULL,TRUE,FALSE,NULL); 
	
    if(!WriteFile(hUsb,Outbuff,len,&nBytesWrite,&ol)) 
    {
		//Ϣ--------------------------------
        if((lrc=GetLastError())==ERROR_IO_PENDING)
        {
            endtime=GetTickCount()+1000;
            while(!GetOverlappedResult(hUsb,&ol,&nBytesWrite,FALSE))
            {   
                dwError=GetLastError();
                if(GetTickCount()>endtime)
                {   
					char buf[1000];
					sprintf(buf,"дʱĿǰڷͻеĿΪol.hEvent=%x,dwError=%d,nBytesWrite=%d",ol.hEvent,dwError,nBytesWrite);
					
                    MessageBox(NULL,buf,NULL,NULL);
                    break;
                }
                if(dwError=ERROR_IO_INCOMPLETE) 
                    continue;          //δȫʱؽ
                else
                {
                    //    󣬳Իָ                    
                    break;
                }
            }
        } 
		//-------------------------------------------------//          
    }    
	//char buf[1000];
    // sprintf(buf,"дʱĿǰڷͻеĿΪol.hEvent=%x,dwError=%d,nBytesWrite=%d",ol.hEvent,dwError,nBytesWrite);
	
	// MessageBox(NULL,buf,NULL,NULL);
    CloseHandle(ol.hEvent);
    FlushFileBuffers(hUsb);    
    return 1;
}

int ReadUsb(HANDLE hUsb,BYTE inbuff[], DWORD &nBytesRead,int nToRead)
{
    DWORD lrc;                                 ///У
    DWORD endtime;                            /////////jiesuo
    static OVERLAPPED ol;
    int ReadNumber=0;    
    int numCount=0 ;                             //ƶȡĿ
    DWORD dwErrorMask;      
	DWORD dwEvtMask=0 ; 
	DWORD      ntoread;
	int          ReadTime;
	
    ReadTime=2000;
    ntoread=nToRead;
	ol.Offset=0;                            ///ļʼֽƫ
    ol.OffsetHigh=0;                        ///ʼݵֽƫĸλ֣ܵͨʱý̿ɺԡ
    ol.hEvent=NULL;                         ///ʶ¼ݴʱΪź״̬
    ol.hEvent=CreateEvent(NULL,TRUE,FALSE,NULL); 
    if(!ReadFile(hUsb,inbuff,ntoread,&nBytesRead,&ol))
    {    
        if((lrc=GetLastError())==ERROR_IO_PENDING)
        {
            ///////////////////
            endtime=GetTickCount()+ReadTime;//GetTickCount()ȡϵͳʼõʱ()
            while(!GetOverlappedResult(hUsb,&ol,&nBytesRead,FALSE))//úȡصĽ
            {
                if(GetTickCount()>endtime)
                    break;
            }    
        }        
    }     
	CloseHandle(ol.hEvent);
    return 1;     
}
*/
